VERSION 1.0 CLASS
BEGIN
  MultiUse = -1  'True
  Persistable = 0  'NotPersistable
  DataBindingBehavior = 0  'vbNone
  DataSourceBehavior  = 0  'vbNone
  MTSTransactionMode  = 0  'NotAnMTSObject
END
Attribute VB_Name = "Display"
Attribute VB_GlobalNameSpace = False
Attribute VB_Creatable = True
Attribute VB_PredeclaredId = False
Attribute VB_Exposed = True
Option Explicit

'Declare ScriptingContext variables
Private m_Application As Application
Private m_Request As Request
Private m_Response As Response
Private m_Session As Session

'Declare Database variables
Private m_objConn As New ADODB.Connection
Private m_objRs As New ADODB.Recordset

'Declare Class variables
Private m_blnProceed As Boolean

Public Sub AllAuthors()
   'Declare local variables
   Dim strSQL, strOrderBy As String
   Dim intCount As Integer

   'Open the database and check for errors
   If Not OpenDatabase Then
      m_Response.Write "<P><strong><font color=""#FF0000"">" & _
         "Error Opening Database</font></strong><P>"
      Exit Sub
   End If
   
   'Build the order by clause based on request.form("AuthorOption")
   Select Case CInt(m_Request.Form("AuthorOption"))
      Case 0
         strOrderBy = "order by au_lname"
      Case 1
         strOrderBy = "order by au_fname"
      Case 2
         strOrderBy = "order by title"
      Case Else
         strOrderBy = ""
   End Select

   'Set the SQL string
   strSQL = "select au_lname, au_fname, pubdate, title " & _
      "From Authors " & _
      "join titleauthor on authors.au_id = titleauthor.au_id " & _
      "join titles on titleauthor.title_id = titles.title_id " & _
      strOrderBy
   
   On Error GoTo SQLErr
   'Set the cursorlocation
   m_objRs.CursorLocation = adUseClient
   'Open the recordset
   m_objRs.Open strSQL, m_objConn, adOpenForwardOnly, , adCmdText
   'Set the recordset to no active connection
   Set m_objRs.ActiveConnection = Nothing
   On Error GoTo 0
   
   'Close the database to free the connection
   Call CloseDatabase
   
   'Build the first part of the table containing all header information
   m_Response.Write "<table border=""1""><tr>"
   m_Response.Write "<th nowrap bgcolor=""#800000""><font color=""#FFFFFF"">" & _
      "Last Name</font></th>"
   m_Response.Write "<th nowrap bgcolor=""#800000""><font color=""#FFFFFF"">" & _
      "First Name</font></th>"
   m_Response.Write "<th nowrap bgcolor=""#800000""><font color=""#FFFFFF"">" & _
      "Dated Published</font></th>"
   m_Response.Write "<th nowrap bgcolor=""#800000""><font color=""#FFFFFF"">" & _
      "Book Title</font></th>"
   m_Response.Write "<th nowrap bgcolor=""#800000""><font color=""#FFFFFF"">" & _
      "Order</font></th>"
   m_Response.Write "</tr>"
   
   'Loop through the recordset building each row of the table
   Do While Not m_objRs.EOF
      intCount = intCount + 1
      m_Response.Write "<tr>"
      m_Response.Write "<td bgcolor=""#C0C0C0"">" & m_objRs!au_lname & _
         "</td>"
      m_Response.Write "<td bgcolor=""#C0C0C0"">" & m_objRs!au_fname & _
         "</td>"
      m_Response.Write "<td bgcolor=""#C0C0C0"">" & _
         Format(m_objRs!pubdate, "mm/dd/yyyy") & "</td>"
      m_Response.Write "<td bgcolor=""#C0C0C0"">" & m_objRs!Title & _
         "</td>"
      m_Response.Write "<td bgcolor=""#C0C0C0"">" & _
         "<input type=""text"" size=""5"" name=""" & "txtOrder" & _
         intCount & """ value></td>"
      m_Response.Write "</tr>"
      m_objRs.MoveNext
   Loop
   
   'Build the last part of the table
   m_Response.Write "</table>"
   
   'Close the recordset
   Call CloseRecordset
   
   Exit Sub
   
SQLErr:
   m_Response.Write "<P><strong><font color=""#FF0000"">" & _
      "SQL Error Occurred Reading From The Database</font></strong><P>"
End Sub


Private Sub CloseDatabase()
   'Close database objects and dereference them
   m_objConn.Close
   Set m_objConn = Nothing
End Sub
Private Sub CloseRecordset()
   'Close recordset objects and dereference them
   m_objRs.Close
   Set m_objRs = Nothing
End Sub


Public Sub OnEndPage()
   'Dereference all ScriptingContext objects
   Set m_Application = Nothing
   Set m_Request = Nothing
   Set m_Response = Nothing
   Set m_Session = Nothing
End Sub

Private Function OpenDatabase() As Boolean
   'Connect to SQL Server and open the database
   On Error GoTo SQLErr
   With m_objConn
      .ConnectionTimeout = CInt(m_Session("ConnectionTimeout"))
      .CommandTimeout = CInt(m_Session("CommandTimeout"))
      .Open m_Application("ConnectString")
   End With
   On Error GoTo 0
   OpenDatabase = True
   Exit Function
SQLErr:
   OpenDatabase = False
End Function
Public Sub OnStartPage(m_ScriptingContext As ScriptingContext)
   'Set references to the Web's ScriptingContext objects
   Set m_Application = m_ScriptingContext.Application
   Set m_Request = m_ScriptingContext.Request
   Set m_Response = m_ScriptingContext.Response
   Set m_Session = m_ScriptingContext.Session
End Sub

